package com.patzn.lims.res.enums;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

/**
 * <p>
 * 操作类型枚举
 * </p>
 *
 * @author zhaokai
 * @since 2018-11-21
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum FlowTypeEnum {

    FLOW(0, "流转"),
    BACK(1, "退回"),
    UPDATE(2, "更新"),
    FORWARD(3, "转发"),
    FILE(4, "文件"),
    ;

    private int value;
    private String display;

    FlowTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name();
    }

    public String getDisplay() {
        return display;
    }
}
