package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 标签类型枚举
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-27
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum LabelTypeEnum implements IBaseEnum {
    /**
     * 标签类型
     */
    ENV_SAMPLE_S(0, "环境样品小标签"),
    ENV_SAMPLE_L(1, "环境样品大标签"),
    ENV_LAB_S(2, "环境加密小标签"),
    ENV_LAB_L(3, "环境加密大标签"),
    FOOD_COM_TEST(4, "食品企业检样标签"),
    FOOD_GOV_TEST(5, "食品政府检样标签"),
    FOOD_COM_RETENTION(6, "食品企业留样标签"),
    FOOD_GOV_RETENTION(7, "食品政府留样标签"),
    FOOD_COM_BACK(8, "食品企业备样标签"),
    FOOD_GOV_BACK(9, "食品政府备样标签"),
    FOOD_MAKE(10, "食品制备标签"),
    FOOD_COM_LAB(11, "食品企业加密标签"),
    FOOD_GOV_LAB(12, "食品政府加密标签"),
    ;

    private int value;
    private String display;

    LabelTypeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}