package com.patzn.lims.res.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.common.CommonConstants;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 报销类型枚举
 * </p>
 *
 * @author zhaokai
 * @since 2010-08-01
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum LmsExpensesStatusEnum implements IBaseEnum {

    DRAFT("DRAFT", "草稿"),
    REVIEW("REVIEW", "待审核"),
    SEND("SEND", "待发放"),
    END("END", "已发放"),
    ;

    private String value;
    private String display;

    LmsExpensesStatusEnum(final String value, final String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    /**
     * 流程初始化状态
     */
    public String flowInitStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(value).append(CommonConstants.SYMBOL_JING);
        sb.append(ComponentFlowStatusEnum.INIT.getValue());
        return sb.toString();
    }

    /**
     * 流程通过状态
     */
    public String flowPassStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(value).append(CommonConstants.SYMBOL_JING);
        sb.append(ComponentFlowStatusEnum.PASS.getValue());
        return sb.toString();
    }

    /**
     * 流程退回状态
     */
    public String flowBackStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append(value).append(CommonConstants.SYMBOL_JING);
        sb.append(ComponentFlowStatusEnum.BACK.getValue());
        return sb.toString();
    }

    public static String display(String text) {
        if (null != text && text.contains(CommonConstants.SYMBOL_JING)) {
            String[] temp = text.split(CommonConstants.SYMBOL_JING);
            return ComponentFlowStatusEnum.display(from(temp[0]), temp);
        }
        return CommonConstants.SYMBOL_GANG;
    }

    public static LmsExpensesStatusEnum from(String value) {
        if (null != value && value.contains(CommonConstants.SYMBOL_JING)) {
            value = value.split(CommonConstants.SYMBOL_JING)[0];
        }
        LmsExpensesStatusEnum[] cse = LmsExpensesStatusEnum.values();
        for (LmsExpensesStatusEnum cs : cse) {
            if (cs.value.equals(value)) {
                return cs;
            }
        }
        return null;
    }
}