package com.patzn.lims.res.enums;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 报销类型枚举
 * </p>
 *
 * @author zhaokai
 * @since 2010-08-01
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum LmsExpensesTypeEnum implements IBaseEnum {

    TRAVEL("差旅报销单"),
    COST("费用报销单"),
    CAR_COST("车辆费用报销"),
    PAYMENT("付款申请单"),
    BORROW("借款单"),
    ;

    private String value;

    LmsExpensesTypeEnum(final String value) {
        this.value = value;
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDisplay() {
        return null;
    }
}