package com.patzn.lims.res.enums;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 签章类型枚举
 * </p>
 *
 * @author ldx
 * @since 2018-09-29
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SignatureClassifyEnum implements IBaseEnum {
    /**
     * 签章类型
     */
    RIDING(0, "骑缝章"),
    TEST(1, "检验章"),
    APTITUDE(2, "资质章"),
    ORIGINAL(3, "正本"),
    COPY(4, "副本"),
    QUOTATION(5, "报价专用章"),
    PUBLIC(6, "公章"),
    CMA(7, "CMA章"),
    CNAS(8, "CNAS章"),
    CATL(9, "CATL章"),
    OTHER(10, "其他"),
    ;

    private int value;
    private String display;

    SignatureClassifyEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    public int getIntValue() {
        return value;
    }
}