package com.patzn.lims.res.enums;
import com.patzn.lims.core.enums.IBaseEnum;

import java.io.Serializable;

/**
 * @author zk
 */
public enum StaffTrainPlanStatusEnum implements IBaseEnum {
    CANCEL(00, "作废"),
    DRAFT(10, "草稿"),
    SUBMITTED(20, "已提交"),
    AUDITED(30, "已审核");

    private int value;
    private String display;

    StaffTrainPlanStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }

    @Override
    public String getName() {
        return getName();
    }

    @Override
    public String getDisplay() {
        return display;
    }

    @Override
    public Serializable getValue() {
        return value;
    }

    public static StaffTrainPlanStatusEnum[] getValues() {
        return StaffTrainPlanStatusEnum.values();
    }
}
