package com.patzn.lims.res.flow;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 业务组件流
 * </p>
 *
 * @author hubin
 * @since 2018-05-18
 */
public class ComponentFlow implements Serializable {

    /**
     * 上一节点
     */
    private List<Component> previousList;

    /**
     * 下一节点
     */
    private List<Component> nextList;

    /**
     * 组件节点名
     */
    private String name;

    public ComponentFlow() {
        // to do nothing
    }

    public ComponentFlow(String name, List<Component> previousList, List<Component> nextList) {
        this.name = name;
        this.previousList = previousList;
        this.nextList = nextList;
    }

    public List<Component> getPreviousList() {
        return previousList;
    }

    public void setPreviousList(List<Component> previousList) {
        this.previousList = previousList;
    }

    public List<Component> getNextList() {
        return nextList;
    }

    public void setNextList(List<Component> nextList) {
        this.nextList = nextList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
