package com.patzn.lims.res.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.res.entity.LmsComponentFlow;
import com.patzn.lims.res.enums.ComponentFlowTypeEnum;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2018-05-17
 */
public interface LmsComponentFlowMapper extends BaseMapper<LmsComponentFlow> {
    @SqlParser(filter = true)
    List<LmsComponentFlow> selectComponentList();


    @SqlParser(filter = true)
    List<LmsComponentFlow> selectListByTypeCompanyId(@Param("type") Integer type, @Param("companyId") Long companyId);


    @SqlParser(filter = true)
    LmsComponentFlow selectOneByComponentFlow(@Param("type") ComponentFlowTypeEnum type, @Param("companyId") Long companyId);

    @SqlParser(filter = true)
    LmsComponentFlow selectByIdWithoutCompanyId(@Param("id") Long id);

    @SqlParser(filter = true)
    int updateByIdWithoutCompanyId(LmsComponentFlow entity);

}
