package com.patzn.lims.res.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.res.entity.LmsSupplier;
import com.patzn.lims.res.vo.LmsSupplierTypeVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 供应商表 Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
public interface LmsSupplierMapper extends BaseMapper<LmsSupplier> {


    List<LmsSupplierTypeVO> pageTypeVO(Page rowBounds, @Param("supplier") LmsSupplierTypeVO lmsSupplier);


    List<LmsSupplier> selectByClassifyChemical(Page rowBounds, @Param("classId") Long classId, @Param("ew") QueryWrapper<LmsSupplier> entityWrapper);


    List<LmsSupplier> selectByChemical(Page rowBounds, @Param("chemicalId") Long classId, @Param("ew") QueryWrapper<LmsSupplier> entityWrapper);



   @SqlParser(filter = true)
    List<LmsSupplier> selectNoLogin(@Param("ew") LmsSupplier ew);


    List<LmsSupplierTypeVO> pageSupplier(Page page, @Param("supplier") LmsSupplierTypeVO lmsSupplier);
}