package com.patzn.lims.res.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.res.entity.LmsUserGroup;
import com.patzn.lims.res.vo.LmsUserGroupVO;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
public interface LmsUserGroupMapper extends BaseMapper<LmsUserGroup> {


    List<LmsUserGroupVO> selectGroupList(Page page, @Param("userGroup") LmsUserGroupVO userGroup);


    List<LmsUserGroupVO> selectGroupListNoPage(@Param("userGroup") LmsUserGroup userGroup);


    List<LmsUserGroupVO> selectGroupListByUserId(Page page, @Param("uid") Long uid);


    List<LmsUserGroup> selectNoLeaderGroupList(@Param("groupIds") Collection<Long> groupIds, @Param("userId") Long userId);


    List<LmsUserGroup> selectListIdNotInGroupList(@Param("groupIds") Collection<Long> groupIds);


    List<LmsUserGroup> selectListByUserId(@Param("userId") Long userId);


    List<LmsUserGroup> selectNoLogin(@Param("ew") LmsUserGroup userGroup);


    List<LmsUserGroupVO> selectGroups(Page page, @Param("vo") LmsUserGroupVO vo);

    /**
     * 根据小组长的Id获取用户组
     * @param userId
     * @return
     */
    List<LmsUserGroup> getByLeaderUserId(Long userId);
}
