package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsBaseDict;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 字典表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
public interface ILmsBaseDictService extends IBaseService<LmsBaseDict> {


    Page<LmsBaseDict> page(Page<LmsBaseDict> page, LmsBaseDict lmsBaseDict);


    List<LmsBaseDict> getDictAllTree(String name);


    LmsBaseDict getDictByNameType(LmsBaseDict dict);


    List<LmsBaseDict>  getDictQuery(LmsBaseDict dict);


    List<LmsBaseDict> getDictAllByClass(String classType, String name);


    List<LmsBaseDict> getDictDetailByClass(String name);


    LmsBaseDict getByKey(String key);


    /**
     * <p>
     * 查询 CODE 值
     * </p>
     *
     * @param type 分类
     * @param name 名称
     * @return
     */
    String getCode(String type, String name);

    /**
     * <p>
     * 查询 CODE 值
     * </p>
     *
     * @param type    分类
     * @param keyword 关键字
     * @return
     */
    String getCodeByKeyword(String type, String keyword);


    /**
     * <p>
     * 字典相关内容初始化
     * </p>
     *
     * @param companyId 企业 ID
     * @return
     */
    boolean initBaseDict(Long companyId);


    List<LmsBaseDict> getDictTypeNoRepeat();


    List<LmsBaseDict> getNoRepeatlByType(String type);



    boolean baseDictImport(MultipartFile file);

    /**
     * 根据type获取名字
     *
     * @param type
     * @return
     */
    List<LmsBaseDict> getNameByType(String type);



    void export(HttpServletResponse response, Long currentCompanyId);


    List<List<LmsBaseDict>> listDict(String[] classTypeList);
}
