package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.bean.BaseEntity;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsCodeRule;
import com.patzn.lims.res.entity.LmsCodeRuleRecord;
import com.patzn.lims.res.enums.CodeTypeEnum;

/**
 * <p>
 * 编号规则 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-04-11
 */
public interface ILmsCodeRuleService extends IBaseService<LmsCodeRule> {

    Page<LmsCodeRule> page(Page<LmsCodeRule> page, LmsCodeRule lmsCodeRule);


    String getKey(Integer codeType, String codeName, BaseEntity entity);


    String getKey(CodeTypeEnum codeTypeEnum, BaseEntity entity);


    int getKeySnLength(CodeTypeEnum codeTypeEnum, BaseEntity entity);


    boolean initBaseCodeRule(Long companyId);


    LmsCodeRule getCodeRule(CodeTypeEnum codeType);


    /**
     * <p>
     * 修改编号规则
     * </p>
     *
     * @param lmsCodeRule
     * @return
     */
    Boolean updateCodeRule(LmsCodeRule lmsCodeRule);

    /**
     * <p>
     * 编号规则记录分页列表
     * </p>
     *
     * @param page
     * @param record
     * @return
     */
    Page<LmsCodeRuleRecord> pageRecord(Page<LmsCodeRuleRecord> page, LmsCodeRuleRecord record);

    /**
     * <p>
     * 修改编号规则的序列号
     * </p>
     *
     * @param id
     * @param sn
     * @return
     */
    boolean editRecord(Long id, Integer sn);
}
