package com.patzn.lims.res.service;

import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsCustomerDetail;

/**
 * <p>
 * 客户信息详情表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
public interface ILmsCustomerDetailService extends IBaseService<LmsCustomerDetail> {


    /**
     * <p>
     * 根据客户 ID 查询详情信息
     * </p>
     *
     * @param customerId 客户 ID
     * @return
     */
    LmsCustomerDetail getByCustomerId(Long customerId);


    /**
     * <p>
     * 根据客户 ID 更新详情信息
     * </p>
     *
     * @param customerDetail 客户详情对象
     * @return
     */
    boolean updateByCustomerId(LmsCustomerDetail customerDetail);


    /**
     * <p>
     * 根据客户 ID 删除详情信息
     * </p>
     *
     * @param customerId 客户 ID
     * @return
     */
    boolean removeByCustomerId(Long customerId);
}
