package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsCustomer;
import com.patzn.lims.res.entity.LmsCustomerDetail;
import com.patzn.lims.res.vo.LmsCustomerBriefVO;
import com.patzn.lims.res.vo.LmsCustomerDetailVO;
import com.patzn.lims.res.vo.LmsCustomerVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 客户信息表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
public interface ILmsCustomerService extends IBaseService<LmsCustomer> {


    Page<LmsCustomerDetailVO> page(Page<LmsCustomerDetailVO> page, LmsCustomerDetailVO vo);


    List<LmsCustomerDetailVO> list(LmsCustomerDetailVO vo);


    List<LmsCustomer> listAll();


    LmsCustomerVO getVoById(Long customerId);


    boolean save(LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail);


    boolean saveOrUpdate(LmsCustomer lmsCustomer);


    boolean updateById(LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail);





    List<LmsCustomerBriefVO> listNew(String cname);


    boolean importItem(MultipartFile file);


    LmsCustomer getOneByName(String cusName);
}
