package com.patzn.lims.res.service;

import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.dto.LmsFormDto;
import com.patzn.lims.res.entity.LmsForm;

import java.util.List;

/**
 * <p>
 * 自定义表单服务类
 * </p>
 *
 * @author hubin
 * @since 2020-04-15
 */
public interface ILmsFormService extends IBaseService<LmsForm> {

    /**
     * 保存自定义表单
     *
     * @param title 标题
     * @param json  JSON 对象
     * @return
     */
    Long save(String title, String json);

    /**
     * 根据 主键 ID 更新
     *
     * @param dto 主键 ID
     * @return
     */
    boolean updateById(LmsFormDto dto);

    /**
     * 根据标题模糊查询自定义表单
     *
     * @param title 标题
     * @return
     */
    List<LmsForm> listByTitle(String title);

    /**
     * 根据标题获取自定义表单
     *
     * @param title 标题
     * @return
     */
    LmsForm getByTitle(String title);

    /**
     * 判断标题是否存在
     *
     * @param title 标题
     * @return
     */
    boolean existByTitle(String title);

    /**
     * 根据 主键 ID 删除
     *
     * @param id 主键 ID
     * @return
     */
    boolean removeById(Long id);
}
