package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.dto.LmsSupplierDTO;
import com.patzn.lims.res.entity.LmsSupplier;
import com.patzn.lims.res.entity.LmsSupplierDetail;
import com.patzn.lims.res.vo.LmsSupplierTypeVO;
import com.patzn.lims.res.vo.LmsSupplierVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 供应商表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
public interface ILmsSupplierService extends IBaseService<LmsSupplier> {


    Page<LmsSupplier> page(Page<LmsSupplier> page, LmsSupplier lmsSupplier);


    Page<LmsSupplierTypeVO> pageTypeVO(Page<LmsSupplierTypeVO> page, LmsSupplierTypeVO lmsSupplier);


    List<LmsSupplier> list(LmsSupplier lmsSupplier);


    List<LmsSupplier> listNoLogin(LmsSupplier lmsSupplier);


    List<LmsSupplier> listByName(String name);

    List<LmsSupplier> listByNameNotLike(String name);


    List<LmsSupplier> listByNames(Set<String> list);


    LmsSupplierVO getVoById(Long id);


    boolean save(LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail);


    boolean updateById(LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail);


    boolean removeById(Long id);


    Page<LmsSupplier> pageByClassify(Page<LmsSupplier> page, Long classId, LmsSupplier lmsSupplier);


    Page<LmsSupplier> pageByChemical(Page<LmsSupplier> page, Long chemicalId, LmsSupplier lmsSupplier);


    void exportSupplier(HttpServletResponse response, LmsSupplierDTO dto);


    boolean importItem(MultipartFile file);


    Set<String> getAllSupplier();

    /**
     * 根据供应商名称模糊供应商
     * @param supplier
     * @return
     */
    Set<String> getAllSupplierByName(String supplier);

    List<LmsSupplier>getListByIds(List<Long> ids);


    List<LmsSupplier> getListByNames(List<String> names);


    boolean importSupplier(MultipartFile file);

    /*新供应商管理列表*/
    Page<LmsSupplierTypeVO> pageSupplier(Page<LmsSupplierTypeVO> page, LmsSupplierTypeVO lmsSupplier);

    void exportSupplierWjl(HttpServletResponse response, LmsSupplierDTO dto);

    LmsSupplierTypeVO getTempVO();
}
