package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsUnit;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 单位表 服务类
 * </p>
 *
 * @author patzn
 * @since 2017-11-29
 */
public interface ILmsUnitService extends IBaseService<LmsUnit> {

    Page<LmsUnit> page(Page<LmsUnit> page, LmsUnit lmsUnit);


    List<LmsUnit> list(LmsUnit lmsUnit);


    int count(Collection<String> names);


    /**
     * <p>
     * 导入单位
     * </p>
     *
     * @param file 导入 XLSX
     * @return
     */
    boolean importUnit(MultipartFile file);

    int countForChemical(Collection<String> names);

    /**
     * <p>
     * 根据 name 获取 unit
     * </p>
     *
     * @param exunit
     * @return
     */
    List<LmsUnit> listUnit(Collection<String> exunit);
}
