package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.entity.LmsUserGroup;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.vo.LmsUserGroupVO;
import com.patzn.lims.res.vo.LmsUserRelGroupVO;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
public interface ILmsUserGroupService extends IBaseService<LmsUserGroup> {


    Page<LmsUserGroup> page(Page<LmsUserGroup> page, LmsUserGroup lmsUserGroup);


    Page<LmsUserGroupVO> pageUserGroup(Page<LmsUserGroupVO> page, LmsUserGroupVO lmsUserGroup);


    List<LmsUserGroupVO> listUserGroup(LmsUserGroup lmsUserGroup);


    List<LmsUserGroup> list(LmsUserGroup lmsUserGroup);


    List<LmsUserGroup> listNoLogin(LmsUserGroup lmsUserGroup);


    /**
     * <p>
     * 用户编组添加人员
     * </p>
     */
    boolean saveUserRelGroup(Long groupId, Long[] userIds, String[] realNames, String[] usernames);

    /**
     *<p>
     *     用户编组删除人员
     *</p>
     */
    boolean deleteRelUser(Long[] ids);

    /**
     *<p>
     *     用户编组获取人员page列表
     *</p>
     */
    Page<LmsUserRelGroup> getPageRelUser(Page<LmsUserRelGroup> page, LmsUserRelGroup lmsUserRelGroup);




    List<LmsUserGroup>   listGroupByNameList(Collection<String> groupNames);


    List<LmsUserGroup>   listGroupByIds(Collection<Long> ids);


    List<LmsUserGroup>   getByUserId(Long userId);


    List<LmsUserGroup>   getNoLeaderGroup(Collection<Long> groupIds, Long userId);


    List<LmsUserGroup>   getListIdNotIn(Collection<Long> groupIds);


    Page<LmsUserGroupVO>  pageListGroupByUserId(Page<LmsUserGroupVO> page, Long uid);


    Page<LmsUserGroupVO>  pageListGroups(Page<LmsUserGroupVO> page, LmsUserGroupVO vo);


    Page<LmsUserRelGroup> getPageRelUserManyGroup(Page<LmsUserRelGroup> page, LmsUserRelGroupVO vo);

    /**
     * 根据小组长Id获取小组数据
     * @param userId
     * @return
     */
    List<LmsUserGroup> getByLeaderUserId(Long userId);
}
