package com.patzn.lims.res.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.res.dto.LmsUserGroupDTO;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.vo.LmsUserRelGroupVO;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 用户关联组表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
public interface ILmsUserRelGroupService extends IBaseService<LmsUserRelGroup> {


    Page<LmsUserRelGroup> page(Page<LmsUserRelGroup> page, LmsUserRelGroup lmsUserRelGroup);

    Page<LmsUserRelGroup> pageUser(Page<LmsUserRelGroup> page, LmsUserRelGroupVO vo);


    List<LmsUserRelGroup> list(LmsUserRelGroup lmsUserRelGroup);


    boolean setLeader(Long[] ids, String leader);


    List<Long> getAllUserIdByGroup(Long groupId);


    List<LmsUserRelGroup> listUserByGroupIdAndUserName(LmsUserGroupDTO lmsUserGroupDTO);

    List<Long> getAllGroupIdByUserId(Long userId);


    List<LmsUserRelGroup> listGroupUserByUserId(Long currentUserId);


    List<LmsUserRelGroup> getUserByGroupIds(Collection<Long> groupIds);

    List<LmsUserRelGroup> getUserByleader();

    List<LmsUserRelGroup> getListUserByGroupIdByLeader(@RequestBody LmsUserGroupDTO lmsUserGroupDTO);

    List<LmsUserRelGroup> getUserByGroupIdsLeader(Collection<Long> groupIds);

}
