package com.patzn.lims.res.service.impl;

import com.patzn.lims.common.EnumObjectVO;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.res.enums.CodeTypeEnum;
import com.patzn.lims.res.enums.LabelTypeEnum;
import com.patzn.lims.res.enums.LmsExpensesTypeEnum;
import com.patzn.lims.res.enums.SignatureClassifyEnum;
import com.patzn.lims.res.service.IEnumService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhaokai
 * @since 2019-07-27
 */
@Service
public class EnumServiceImpl implements IEnumService {

    private static final Map<String, String> ENUM = new HashMap<>();

    static {
        EnumServiceImpl.ENUM.put("CodeType", CodeTypeEnum.class.getName());
        EnumServiceImpl.ENUM.put("SignatureClassifyEnum", SignatureClassifyEnum.class.getName());
        EnumServiceImpl.ENUM.put(LmsExpensesTypeEnum.class.getSimpleName(), LmsExpensesTypeEnum.class.getName());
        EnumServiceImpl.ENUM.put(LabelTypeEnum.class.getSimpleName(), LabelTypeEnum.class.getName());
    }

    @Override
    public List<EnumObjectVO> getEnumList(String name) {
        PtAssert.fail(null == EnumServiceImpl.ENUM.get(name), "枚举不存请联系管理员");
        try {
            List<EnumObjectVO> enumObjectList = new ArrayList<>();
            Class enumClass = Class.forName(EnumServiceImpl.ENUM.get(name));
            if (enumClass.isEnum()) {
                Enum[] es = (Enum[]) enumClass.getEnumConstants();
                if (SignatureClassifyEnum.class.equals(enumClass)) {
                    // 签章枚举类
                    // 应该放里面的List
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.CMA));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.CNAS));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.CATL));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.ORIGINAL));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.COPY));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.PUBLIC));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.TEST));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.RIDING));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.QUOTATION));
                    enumObjectList.add(new EnumObjectVO(SignatureClassifyEnum.OTHER));
                }  else {
                    for (Enum e : es) {
                        enumObjectList.add(new EnumObjectVO((IBaseEnum) e));
                    }
                }
            }
            return enumObjectList;
        } catch (Exception e) {
            PtAssert.fail("枚举解析异常");
            return null;
        }
    }

}
