package com.patzn.lims.res.service.impl;

import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.res.service.IExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.io.InputStream;
import java.net.URL;

/**
 * <p>
 * 导出相关
 * </p>
 *
 * @author wwd
 * @since 2018-06-13
 */
@Service
public class ExportServiceImpl implements IExportService {

    private final Logger logger = LoggerFactory.getLogger(ExportServiceImpl.class);





    @Override
    public String filePath(String fileName) {
        URL url = this.getClass().getClassLoader().getResource("templates/word/model/" + fileName);
        PtAssert.fail(null == url, fileName + "不存在");
        return url.getPath();
    }

    @Override
    public String fileFolderPath(String folder, String fileName) {
        URL url = this.getClass().getClassLoader().getResource("templates/word/" + folder + "/" + fileName);
        PtAssert.fail(null == url, fileName + "不存在");
        return url.getPath();
    }

    @Override
    public InputStream fileWordInputStreamFolderPath(String folder, String fileName) {
        InputStream io= this.getClass().getClassLoader().getResourceAsStream("templates/word/" + folder + "/" + fileName);
        PtAssert.fail(null == io, fileName + "不存在");
        return io;
    }


    public InputStream fileFolderPath(String fileName) {
        return getClass().getClassLoader().getResourceAsStream("templates/excel/" + fileName);
    }




}