package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCarInfo;
import com.patzn.lims.res.mapper.LmsCarInfoMapper;
import com.patzn.lims.res.service.ILmsCarInfoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-26
 */
@Service
public class LmsCarInfoServiceImpl extends BaseServiceImpl<LmsCarInfoMapper, LmsCarInfo> implements ILmsCarInfoService {


    @Override
    public Page<LmsCarInfo> page(Page<LmsCarInfo> page, LmsCarInfo lmsCarInfo) {
        return page.setRecords(baseMapper.selectCarList(page, lmsCarInfo));
    }



    @Override
    public boolean setStopStart(Long id, Integer status) {
        PtAssert.fail(null==status||(status!=0&&status!=1),"请选择停用还是启用 0停用 1启用");
        PtAssert.fail(null==id,"请选择车辆");
        LmsCarInfo info=new LmsCarInfo();
        info.setId(id);
        if(status==0){
            info.setStatus(1);
        }else if(status==1){
            info.setStatus(0);
        }
        return super.updateById(info);
    }


    @Override
    public List<LmsCarInfo> list(LmsCarInfo lmsCarInfo) {
        QueryWrapper wrapper = Wrappers.query(lmsCarInfo);
        if (StringUtils.isNotBlank(lmsCarInfo.getLicense())) {
            wrapper.like("license", lmsCarInfo.getLicense());
            lmsCarInfo.setLicense(null);
        }
        return this.list(wrapper);
    }


    @Override
    public boolean saveCar(LmsCarInfo lmsCarInfo) {
       PtAssert.fail(StringUtils.isBlank(lmsCarInfo.getLicense()),"车牌号不能为空");
       int count= super.count(Wrappers.query(new LmsCarInfo()).eq("license",lmsCarInfo.getLicense()));
       PtAssert.fail(count>0,"车牌号与已有车辆重复请确认");
       return super.save(lmsCarInfo);
    }


    @Override
    public boolean updateCarById(LmsCarInfo lmsCarInfo) {
        PtAssert.fail(StringUtils.isBlank(lmsCarInfo.getLicense()),"车牌号不能为空");
        PtAssert.fail(null==lmsCarInfo.getId(),"车辆id不能为空");
        int count= super.count(Wrappers.query(new LmsCarInfo()).eq("license",lmsCarInfo.getLicense()).ne("id",lmsCarInfo.getId()));
        PtAssert.fail(count>0,"车牌号与已有车辆重复请确认");
        return super.updateById(lmsCarInfo);
    }

}
