package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCarRecord;
import com.patzn.lims.res.mapper.LmsCarRecordMapper;
import com.patzn.lims.res.service.ILmsCarRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 车辆使用记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-26
 */
@Service
public class LmsCarRecordServiceImpl extends BaseServiceImpl<LmsCarRecordMapper, LmsCarRecord> implements ILmsCarRecordService {


    @Override
    public Page<LmsCarRecord> page(Page<LmsCarRecord> page, LmsCarRecord lmsCarRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsCarRecord);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsCarRecord> list(LmsCarRecord lmsCarRecord) {
        return this.list(Wrappers.query(lmsCarRecord));
    }
}
