package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsClassifyRelGruop;
import com.patzn.lims.res.vo.LmsClassifyRelGruopVO;
import com.patzn.lims.res.mapper.LmsClassifyRelGruopMapper;
import com.patzn.lims.res.service.ILmsClassifyRelGruopService;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 模板类别与用户编组管理表 服务实现类
 * </p>
 *
 * @author SunYunGang
 * @since 2019-06-18
 */
@Service
public class LmsClassifyRelGruopServiceImpl extends BaseServiceImpl<LmsClassifyRelGruopMapper, LmsClassifyRelGruop> implements ILmsClassifyRelGruopService {


    @Override
    public Page<LmsClassifyRelGruop> page(Page<LmsClassifyRelGruop> page, LmsClassifyRelGruop lmsClassifyRelGruop) {
        QueryWrapper wrapper = Wrappers.query(lmsClassifyRelGruop);

        return this.page(page, wrapper);
    }

    @Override
    public     Page<LmsClassifyRelGruopVO> getPageVO(Page<LmsClassifyRelGruopVO> page, LmsClassifyRelGruopVO lmsClassifyRelGruop){
        return page.setRecords(baseMapper.selectVO(page,lmsClassifyRelGruop));
    }

    @Override
    public     boolean bindingUserGroup(Long[]userGruopIds,Long templateClassifyId){
        PtAssert.fail(ArrayUtils.isEmpty(userGruopIds)||null==templateClassifyId,"数据参数错误,请重试");
        List<LmsClassifyRelGruop>list = new ArrayList<>();
        for (Long userGroupId:userGruopIds) {
            list.add(new LmsClassifyRelGruop().setUserGruopId(userGroupId).setTemplateClassifyId(templateClassifyId));
        }
        if(CollectionUtils.isNotEmpty(list)){
            saveBatch(list);
        }
        return true;
    }


    @Override
    public List<LmsClassifyRelGruop> list(LmsClassifyRelGruop lmsClassifyRelGruop) {
        return this.list(Wrappers.query(lmsClassifyRelGruop));
    }
}
