package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsColumnQuestion;
import com.patzn.lims.res.enums.ColumnQuestionBelongEnum;
import com.patzn.lims.res.vo.LmsColumnQuestionVO;
import com.patzn.lims.res.mapper.LmsColumnQuestionMapper;
import com.patzn.lims.res.service.ILmsColumnQuestionService;
import com.patzn.lims.res.service.ILmsQuestionOptionService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * 扩展字段问题表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-24
 */
@Service
public class LmsColumnQuestionServiceImpl extends BaseServiceImpl<LmsColumnQuestionMapper, LmsColumnQuestion> implements ILmsColumnQuestionService {

    @Autowired
    private ILmsQuestionOptionService questionOptionService;

    @Override
    public Page<LmsColumnQuestion> page(Page<LmsColumnQuestion> page, LmsColumnQuestion lmsColumnQuestion) {
        QueryWrapper wrapper = Wrappers.query(lmsColumnQuestion);

        return this.page(page, wrapper);
    }

    @Override
    public List<LmsColumnQuestionVO> listVo(Account account, ColumnQuestionBelongEnum columnQuestionBelongEnum) {
        List<LmsColumnQuestion> cqList = super.list(Wrappers.<LmsColumnQuestion>query().eq("belong", columnQuestionBelongEnum.getValue()).orderBy(true,true,"sort"));
        if (CollectionUtils.isEmpty(cqList)) {
            return null;
        }
        return cqList.stream().map(e -> {
            LmsColumnQuestionVO vo = e.convert(LmsColumnQuestionVO.class);
            vo.setQuestionOptionList(questionOptionService.listByQuestionId(e.getId()));
            return vo;
        }).collect(toList());
    }
}
