package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCustomerAttachment;
import com.patzn.lims.res.mapper.LmsCustomerAttachmentMapper;
import com.patzn.lims.res.service.ILmsCustomerAttachmentService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/**
 * <p>
 * 客户附件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Service
public class LmsCustomerAttachmentServiceImpl extends BaseServiceImpl<LmsCustomerAttachmentMapper, LmsCustomerAttachment> implements ILmsCustomerAttachmentService {



    @Override
    public Page<LmsCustomerAttachment> page(Page<LmsCustomerAttachment> page, LmsCustomerAttachment lmsCustomerAttachment) {
        QueryWrapper wrapper = Wrappers.query(lmsCustomerAttachment);
        wrapper.like("file_name",lmsCustomerAttachment.getFileName());
        lmsCustomerAttachment.setFileName(null);
        return page(page, wrapper);
    }


    @Override
    public List<LmsCustomerAttachment> list(LmsCustomerAttachment lmsCustomerAttachment) {
        return list(Wrappers.query(lmsCustomerAttachment));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(Long customerId, MultipartFile file) {
     return  false;
    }

    @Override
    public void download(Long id, HttpServletResponse response) {


    }

    @Override
    public void downloadFiles(Long[] ids, HttpServletResponse response) {
        List<LmsCustomerAttachment> listAttachment = super.list( Wrappers.<LmsCustomerAttachment>query().in("id", ids));
        try {
            zipFile(response.getOutputStream(), listAttachment);
        } catch (IOException e) {
            e.printStackTrace();
        }

    }
    public void zipFile(OutputStream os, List<LmsCustomerAttachment> listAttachment) throws IOException {
    }
}
