package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCustomerContact;
import com.patzn.lims.res.mapper.LmsCustomerContactMapper;
import com.patzn.lims.res.service.ILmsCustomerContactService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-08-08
 */
@Service
public class LmsCustomerContactServiceImpl extends BaseServiceImpl<LmsCustomerContactMapper, LmsCustomerContact> implements ILmsCustomerContactService {


    @Override
    public Page<LmsCustomerContact> page(Page<LmsCustomerContact> page, LmsCustomerContact lmsCustomerContact) {
        PtAssert.fail(null == lmsCustomerContact || null == lmsCustomerContact.getCustomerId(), "请确认客户");
        QueryWrapper wrapper = Wrappers.query(lmsCustomerContact);
        if (StringUtils.isNotBlank(lmsCustomerContact.getName())) {
            wrapper.like("name", lmsCustomerContact.getName());
            lmsCustomerContact.setName(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsCustomerContact> list(LmsCustomerContact lmsCustomerContact) {
        QueryWrapper wrapper = Wrappers.query(lmsCustomerContact);
        if (StringUtils.isNotBlank(lmsCustomerContact.getName())) {
            wrapper.like("name", lmsCustomerContact.getName());
            lmsCustomerContact.setName(null);
        }
        return list(wrapper);
    }

    @Override
    public List<LmsCustomerContact> listAllByCus(Long customerId) {
        return super.list( Wrappers.<LmsCustomerContact>query().eq("customer_id", customerId));
    }

    @Override
    public List<LmsCustomerContact> getListCustomerContact(LmsCustomerContact lmsCustomerContact) {
        PtAssert.fail(null == lmsCustomerContact || null == lmsCustomerContact.getCustomerId(), "请确认客户");
        QueryWrapper wrapper = Wrappers.<LmsCustomerContact>query().eq("customer_id", lmsCustomerContact.getCustomerId());
        if (StringUtils.isNotEmpty(lmsCustomerContact.getName())) {
            wrapper.like("name", lmsCustomerContact.getName());
            lmsCustomerContact.setName(null);
        }
        wrapper.last("limit 20");
        return baseMapper.selectList(wrapper);
    }
}
