package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCustomerDetail;
import com.patzn.lims.res.mapper.LmsCustomerDetailMapper;
import com.patzn.lims.res.service.ILmsCustomerDetailService;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 客户信息详情表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Service
public class LmsCustomerDetailServiceImpl extends BaseServiceImpl<LmsCustomerDetailMapper, LmsCustomerDetail> implements ILmsCustomerDetailService {


    @Override
    public LmsCustomerDetail getByCustomerId(Long customerId) {
        return super.getOne(Wrappers.<LmsCustomerDetail>query().eq("customer_id", customerId));
    }


    @Override
    public boolean updateByCustomerId(LmsCustomerDetail customerDetail) {
        if (null == customerDetail.getCustomerId()) {
            PtAssert.fail("客户 ID 为 Null 无法更新情况信息。");
        }
        return super.update(customerDetail, Wrappers.<LmsCustomerDetail>query().eq("customer_id", customerDetail.getCustomerId()));
    }


    @Override
    public boolean removeByCustomerId(Long customerId) {
        return super.remove(Wrappers.<LmsCustomerDetail>query().eq("customer_id", customerId));
    }
}
