package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsCustomerRecord;
import com.patzn.lims.res.mapper.LmsCustomerRecordMapper;
import com.patzn.lims.res.service.ILmsCustomerRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 环境合同操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Service
public class LmsCustomerRecordServiceImpl extends BaseServiceImpl<LmsCustomerRecordMapper, LmsCustomerRecord> implements ILmsCustomerRecordService {


    @Override
    public Page<LmsCustomerRecord> page(Page<LmsCustomerRecord> page, LmsCustomerRecord lmsCustomerRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsCustomerRecord);
        if (null !=lmsCustomerRecord.getOrigin()){
            wrapper.like("origin",lmsCustomerRecord.getOrigin());
            lmsCustomerRecord.setOrigin(null);
        }
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsCustomerRecord> list(LmsCustomerRecord lmsCustomerRecord) {
        return this.list(Wrappers.query(lmsCustomerRecord));
    }
}
