package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.ObjectUtils;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.res.entity.LmsCustomer;
import com.patzn.lims.res.entity.LmsCustomerDetail;
import com.patzn.lims.res.entity.LmsCustomerRecord;
import com.patzn.lims.res.entity.LmsProperty;
import com.patzn.lims.res.vo.LmsCustomerBriefVO;
import com.patzn.lims.res.vo.LmsCustomerDetailVO;
import com.patzn.lims.res.vo.LmsCustomerVO;
import com.patzn.lims.common.StringHandleUtils;
import com.patzn.lims.res.mapper.LmsCustomerMapper;
import com.patzn.lims.res.service.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 客户信息表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Service
public class LmsCustomerServiceImpl extends BaseServiceImpl<LmsCustomerMapper, LmsCustomer> implements ILmsCustomerService {

    @Autowired
    private ILmsCustomerDetailService lmsCustomerDetailService;
    @Autowired
    private ILmsBaseDictService lmsBaseDictService;
    @Autowired
    private ILmsCustomerRecordService lmsCustomerRecordService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;

    @Override
    public Page<LmsCustomerDetailVO> page(Page<LmsCustomerDetailVO> page, LmsCustomerDetailVO vo) {
        return page.setRecords(baseMapper.selectPageByVO(page, vo));
    }


    @Override
    public List<LmsCustomerDetailVO> list(LmsCustomerDetailVO vo) {
        return baseMapper.selectByVO(vo);
    }

    @Override
    public List<LmsCustomer> listAll() {
        return super.list( Wrappers.<LmsCustomer>query().select("id", "cname"));
    }


    @Override
    public LmsCustomerVO getVoById(Long customerId) {
        LmsCustomer lmsCustomer = baseMapper.selectById(customerId);
        if (null != lmsCustomer) {
            LmsCustomerVO vo = new LmsCustomerVO();
            vo.setLmsCustomer(lmsCustomer);
            vo.setLmsCustomerDetail(lmsCustomerDetailService.getByCustomerId(customerId));
            return vo;
        }
        return null;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail) {
        if (super.save(lmsCustomer)) {
            lmsCustomerDetail.setCustomerId(lmsCustomer.getId());
            return lmsCustomerDetailService.save(lmsCustomerDetail);
        }
        return false;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveOrUpdate(LmsCustomer lmsCustomer) {
        PtAssert.fail(null == lmsCustomer || StringUtils.isBlank(lmsCustomer.getCname()),"数据传输有误");
        //todo 看是否拼companyId
        LmsCustomer customer = getOne(Wrappers.<LmsCustomer>query().select("id").eq("cname",lmsCustomer.getCname()).last("limit 1"));
        if(null == customer){
            if (super.save(lmsCustomer)) {
                LmsCustomerDetail lmsCustomerDetail = new LmsCustomerDetail();
                lmsCustomerDetail.setCustomerId(lmsCustomer.getId());
                return lmsCustomerDetailService.save(lmsCustomerDetail);
            }
        }else{
            lmsCustomer.setId(customer.getId());
            return updateById(lmsCustomer);
        }
        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateById(LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail) {
        lmsCustomerDetail.setCustomerId(lmsCustomer.getId());

        //记录修改内容
        List<LmsProperty> lmsBaseDictList = lmsPropertyService.listPropertyDetailData("客户信息对比");
        List<String> customerPropertyList = new ArrayList<>();
        Map<String, String> propertyValueMap = new HashMap<>();
        for (LmsProperty dict : lmsBaseDictList) {
            customerPropertyList.add(dict.getCode());
            propertyValueMap.put(dict.getCode(), dict.getName());
        }
        LmsCustomer oldCustomer = super.getById(lmsCustomer.getId());
        Map<String, List<Object>> customerMap = ObjectUtils.compareFields(lmsCustomer, oldCustomer, customerPropertyList);
        List<LmsProperty> lmsBaseDictDetailList = lmsPropertyService.listPropertyDetailData("客户详情对比");
        List<String> customerDetailPropertyList = new ArrayList<>();
        for (LmsProperty lmsBaseDict : lmsBaseDictDetailList) {
            customerDetailPropertyList.add(lmsBaseDict.getCode());
            propertyValueMap.put(lmsBaseDict.getCode(), lmsBaseDict.getName());
        }
        LmsCustomerDetail oldCustomerDetail = lmsCustomerDetailService.getByCustomerId(lmsCustomer.getId());
        Map<String, List<Object>> customerDetailMap = ObjectUtils.compareFields(lmsCustomerDetail, oldCustomerDetail, customerDetailPropertyList);

        String remark = StringHandleUtils.getObjectDifferent("客户信息修改：", propertyValueMap, customerMap, customerDetailMap);
        if (StringUtils.isNotBlank(remark)) {

            LmsCustomerRecord record = new LmsCustomerRecord();
            record.setType(2);
            record.setCustomerId(lmsCustomer.getId());
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setRemark(remark);
            lmsCustomerRecordService.save(record);
        }
        if (lmsCustomerDetailService.updateByCustomerId(lmsCustomerDetail)) {
            return super.updateById(lmsCustomer);
        }

        return false;
    }




    @Override
    public List<LmsCustomerBriefVO> listNew(String cname) {
        return baseMapper.selectNewByVO(cname);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean importItem(MultipartFile file) {return false;
    }

    @Override
    public LmsCustomer getOneByName(String cusName) {
        PtAssert.fail(StringUtils.isBlank(cusName),"委托单位不可为空");
        return super.getOne( Wrappers.<LmsCustomer>query().eq("cname", cusName));
    }


}
