package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsEnvMonitorRecord;
import com.patzn.lims.res.mapper.LmsEnvMonitorRecordMapper;
import com.patzn.lims.res.service.ILmsEnvMonitorRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 检测条件操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Service
public class LmsEnvMonitorRecordServiceImpl extends BaseServiceImpl<LmsEnvMonitorRecordMapper, LmsEnvMonitorRecord> implements ILmsEnvMonitorRecordService {


    @Override
    public Page<LmsEnvMonitorRecord> page(Page<LmsEnvMonitorRecord> page, LmsEnvMonitorRecord lmsEnvMonitorRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsEnvMonitorRecord);
        if (StringUtils.isNotBlank(lmsEnvMonitorRecord.getRemark())){
            wrapper.like("remark",lmsEnvMonitorRecord.getRemark());
            lmsEnvMonitorRecord.setRemark(null);
        }
        wrapper.orderBy(true,true,"ctime");
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsEnvMonitorRecord> list(LmsEnvMonitorRecord lmsEnvMonitorRecord) {
        return this.list(Wrappers.query(lmsEnvMonitorRecord));
    }
}
