package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.dto.LmsFormDto;
import com.patzn.lims.res.entity.LmsForm;
import com.patzn.lims.res.mapper.LmsFormMapper;
import com.patzn.lims.res.service.ILmsFormService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 自定义表单服务实现类
 * </p>
 *
 * @author hubin
 * @since 2020-04-15
 */
@Service
public class LmsFormServiceImpl extends BaseServiceImpl<LmsFormMapper, LmsForm> implements ILmsFormService {

    @Override
    public Long save(String title, String json) {
        PtAssert.fail(existByTitle(title), "该标题存在请修改！");
        LmsForm lmsForm = new LmsForm();
        lmsForm.setId(IdWorker.getId());
        lmsForm.setStatus(1);
        lmsForm.setTitle(title);
        lmsForm.setJson(json);
        return super.save(lmsForm) ? lmsForm.getId() : null;
    }

    @Override
    public boolean updateById(LmsFormDto dto) {
        QueryWrapper<LmsForm> qw = Wrappers.<LmsForm>query().eq("title", dto.getTitle())
                .ne("id", dto.getId());
        PtAssert.fail(super.count(qw) > 0, "该标题存在请修改！");
        LmsForm lmsForm = new LmsForm();
        lmsForm.setId(dto.getId());
        lmsForm.setTitle(dto.getTitle());
        lmsForm.setJson(dto.getJson());
        return super.updateById(lmsForm);
    }

    /**
     * status 0，禁用 1，正常 2，已经使用不允许删除
     */
    @Override
    public List<LmsForm> listByTitle(String title) {
        QueryWrapper<LmsForm> wrapper = Wrappers.<LmsForm>query().select("id", "title", "json");
        wrapper.ne("status", 0).like(StringUtils.isNoneBlank(title), "title", title);
        return super.list(wrapper);
    }

    @Override
    public LmsForm getByTitle(String title) {
        LmsForm lmsForm = super.getOne(Wrappers.<LmsForm>query().eq("title", title)
                .ne("status", 0).last("LIMIT 1"));
        if (null != lmsForm && 1 == lmsForm.getStatus()) {
            LmsForm lf = new LmsForm();
            lf.setId(lmsForm.getId());
            lf.setStatus(2);
            super.updateById(lf);
        }
        return lmsForm;
    }

    @Override
    public boolean existByTitle(String title) {
        return super.count(Wrappers.<LmsForm>query().ne("status", 0).eq("title", title)) > 0;
    }

    @Override
    public boolean removeById(Long id) {
        LmsForm lmsForm = super.getById(id);
        if (null != lmsForm) {
            if(2 == lmsForm.getStatus()) {
                // 已经被使用只能禁用
                LmsForm lf = new LmsForm();
                lf.setId(lmsForm.getId());
                lf.setStatus(0);
                return super.updateById(lf);
            }
            else if(1 == lmsForm.getStatus()) {
                // 正常状态未使用删除
                return super.removeById(id);
            }
        }
        return true;
    }
}
