package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.CommonConstants;
import com.patzn.lims.common.ObjectUtils;
import com.patzn.lims.common.StringHandleUtils;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.res.entity.LmsProperty;
import com.patzn.lims.res.mapper.LmsPropertyMapper;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Service
public class LmsPropertyServiceImpl extends BaseServiceImpl<LmsPropertyMapper, LmsProperty> implements ILmsPropertyService {


    @Override
    public Page<LmsProperty> page(Page<LmsProperty> page, LmsProperty lmsProperty) {
        QueryWrapper wrapper = Wrappers.query(lmsProperty);
        return page(page, wrapper);
    }


    @Override
    public List<LmsProperty> list(LmsProperty lmsProperty) {
        return list(Wrappers.query(lmsProperty));
    }


    @Override
    public Map<String, Object> getPropertyDetailData(String type) {


        List<LmsProperty> list=listPropertyDetailData(type);

        Map<String,String> propertyMap=new HashMap<>();
        List<String> propertyList=new ArrayList<>();
        for (LmsProperty property:list) {
            propertyList.add(property.getCode());
            propertyMap.put(property.getCode(),property.getName());
        }

        Map<String,Object> objectMap=new HashMap<>();
        objectMap.put("property",propertyList);
        objectMap.put("propertyMap",propertyMap);
        return objectMap;
    }

    @Override
    public String getObjectCompareDifferent(Object one, Object old, String type,String title) {
        Map<String, Object> map=  getPropertyDetailData(type);
        List<String> propertyList= (List<String>)map.get("property");
        Map<String,String> propertyValueMap= (Map<String,String>)map.get("propertyMap");
        Map<String,List<Object>> returnMap= ObjectUtils.compareFields(one,old,propertyList);
        return StringHandleUtils.getObjectDifferent(title,propertyValueMap,returnMap);
    }

    @Override
    public String getCompareDifferent(Object one, Object old, String type, String title) {
        Map<String, Object> map = getPropertyDetail(type);
        List<String> propertyList = (List<String>) map.get("property");
        Map<String, String> propertyValueMap = (Map<String, String>) map.get("propertyMap");
        Map<String, List<Object>> returnMap = ObjectUtils.compareFields(one, old, propertyList);
        return StringHandleUtils.getObjectDifferent(title, propertyValueMap, returnMap);
    }
    @Override
    public  String getCompareTimeFormatDifferent(Object one, Object old, String type, String title) {
        Map<String, Object> map = getPropertyDetail(type);
        List<String> propertyList = (List<String>) map.get("property");
        Map<String, String> propertyValueMap = (Map<String, String>) map.get("propertyMap");
        Map<String, List<Object>> returnMap = ObjectUtils.compareTimeFormatFields(one, old, propertyList);
        return StringHandleUtils.getObjectDifferent(title, propertyValueMap, returnMap);
    }

    private Map<String, Object> getPropertyDetail(String type) {
        List<LmsProperty> list = baseMapper.selectLmsPropertyList(type);

        Map<String, String> propertyMap = new HashMap<>();
        List<String> propertyList = new ArrayList<>();
        for (LmsProperty property : list) {
            propertyList.add(property.getCode());
            propertyMap.put(property.getCode(), property.getName());
        }

        Map<String, Object> objectMap = new HashMap<>();
        objectMap.put("property", propertyList);
        objectMap.put("propertyMap", propertyMap);
        return objectMap;
    }

    @Override
    public String getObjectCompareDifferent(Map<String, List<Object>> mapCompare, String title) {

        List<Map<String,List<Object>>> list=new ArrayList<>();
        Map<String,String> allProperty=new HashMap<>();
        for (Map.Entry<String, List<Object>> mapEntry: mapCompare.entrySet()) {
            Map<String, Object> map=  getPropertyDetailData(mapEntry.getKey());
            List<String> propertyList= (List<String>)map.get("property");
            Map<String,String> propertyValueMap= (Map<String,String>)map.get("propertyMap");
            Map<String,List<Object>> returnMap= ObjectUtils.compareFields(mapEntry.getValue().get(0),mapEntry.getValue().get(1),propertyList);
            allProperty.putAll(propertyValueMap);
            list.add(returnMap);
        }
        return StringHandleUtils.getObjectDifferent(title,allProperty,list);


    }




    @Override
    public List<LmsProperty> listPropertyDetailData(String type) {
        StringBuilder key = new StringBuilder();
        key.append(LoginHelper.getAccount().getCompanyId()).append(CommonConstants.SYMBOL_JING).append(type);
        List<LmsProperty> returnList=baseMapper.selectLmsPropertyList(type);
        return returnList;
    }
}
