package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsQuestionOption;
import com.patzn.lims.res.mapper.LmsQuestionOptionMapper;
import com.patzn.lims.res.service.ILmsQuestionOptionService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 合同问题选项表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-24
 */
@Service
public class LmsQuestionOptionServiceImpl extends BaseServiceImpl<LmsQuestionOptionMapper, LmsQuestionOption> implements ILmsQuestionOptionService {


    @Override
    public Page<LmsQuestionOption> page(Page<LmsQuestionOption> page, LmsQuestionOption lmsQuestionOption) {
        QueryWrapper wrapper = Wrappers.query(lmsQuestionOption);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsQuestionOption> listByQuestionId(Long questionId) {
        return super.list( Wrappers.<LmsQuestionOption>query().eq("question_id", questionId).orderBy(true,true,"sort"));
    }
}
