package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsSatisfactionItem;
import com.patzn.lims.res.vo.LmsSatisfactionItemIVO;
import com.patzn.lims.res.mapper.LmsSatisfactionItemMapper;
import com.patzn.lims.res.service.ILmsSatisfactionItemService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 客户满意度调查项目表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Service
public class LmsSatisfactionItemServiceImpl extends BaseServiceImpl<LmsSatisfactionItemMapper, LmsSatisfactionItem> implements ILmsSatisfactionItemService {


    @Override
    public Page<LmsSatisfactionItemIVO> page(Page<LmsSatisfactionItemIVO> page, LmsSatisfactionItemIVO lmsSatisfactionItem) {
        if (lmsSatisfactionItem.getId() == null) {
            return page.setRecords(baseMapper.selectPage(page, lmsSatisfactionItem));
        } else {
            return pageVo(page, lmsSatisfactionItem);
        }

    }


    @Override
    public List<LmsSatisfactionItem> list(LmsSatisfactionItem lmsSatisfactionItem) {
        QueryWrapper wrapper = Wrappers.query(lmsSatisfactionItem);
        if (StringUtils.isNotBlank(lmsSatisfactionItem.getName())){
            wrapper.like("name",lmsSatisfactionItem.getName());
            lmsSatisfactionItem.setName(null);
        }
        return this.list(wrapper);
    }


    @Override
    public boolean saveSatisfaction(LmsSatisfactionItem lmsSatisfactionItem) {
        if (null == lmsSatisfactionItem.getPid()) {
            lmsSatisfactionItem.setPid(0L);
        } else {
            LmsSatisfactionItem item = getById(lmsSatisfactionItem.getPid());
            PtAssert.fail(null == item, "上级类别不存在");
            /*暂时不做限制*/
//            PtAssert.fail(!item.getPid().toString().equals("0"),"请选择一级类别");
        }
        List<LmsSatisfactionItem> list = this.list( Wrappers.<LmsSatisfactionItem>query().eq("name", lmsSatisfactionItem.getName()));
        PtAssert.fail(0 < list.size(), "项目名已存在！");
        return save(lmsSatisfactionItem);
    }


    @Override
    public boolean updateSatisfactionById(LmsSatisfactionItem lmsSatisfactionItem) {
        PtAssert.fail(null == lmsSatisfactionItem.getId(), "编辑id不能为空");

        PtAssert.fail(null == lmsSatisfactionItem.getPid(), "上级id不能为空");
        if ("0".equals(lmsSatisfactionItem.getPid().toString())) {
            return updateById(lmsSatisfactionItem);
        }
        LmsSatisfactionItem item = getById(lmsSatisfactionItem.getPid());
        PtAssert.fail(null == item, "上级类别不存在");
        /*PtAssert.fail(!item.getPid().toString().equals("0"), "请选择一级类别");*/
        List<LmsSatisfactionItem> list = this.list( Wrappers.<LmsSatisfactionItem>query().eq("name", lmsSatisfactionItem.getName()));
        PtAssert.fail(0 < list.size(), "项目名已存在！");
        return updateById(lmsSatisfactionItem);
    }

    @Override
    public Page<LmsSatisfactionItemIVO> pageVo(Page<LmsSatisfactionItemIVO> page, LmsSatisfactionItemIVO itemIVO) {
        return page.setRecords(baseMapper.selectPageItem(page, itemIVO));
    }
}
