package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsServiceType;
import com.patzn.lims.res.mapper.LmsServiceTypeMapper;
import com.patzn.lims.res.service.ILmsServiceTypeService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-05-09
 */
@Service
public class LmsServiceTypeServiceImpl extends BaseServiceImpl<LmsServiceTypeMapper, LmsServiceType> implements ILmsServiceTypeService {


    @Override
    public Page<LmsServiceType> page(Page<LmsServiceType> page, LmsServiceType lmsServiceType) {
        QueryWrapper wrapper = Wrappers.query(lmsServiceType);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsServiceType> list(LmsServiceType lmsServiceType) {
        return this.list(Wrappers.query(lmsServiceType));
    }

    @Override
    public LmsServiceType getByName(String name, Long companyId) {
        List<LmsServiceType> list=baseMapper.selectListByName(name,companyId);
        if (CollectionUtils.isEmpty(list)){
            return  null;
        }
        return list.get(0);
    }
}
