package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsSupplierDetail;
import com.patzn.lims.res.mapper.LmsSupplierDetailMapper;
import com.patzn.lims.res.service.ILmsSupplierDetailService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 供应商详情表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Service
public class LmsSupplierDetailServiceImpl extends BaseServiceImpl<LmsSupplierDetailMapper, LmsSupplierDetail> implements ILmsSupplierDetailService {


    @Override
    public Page<LmsSupplierDetail> page(Page<LmsSupplierDetail> page, LmsSupplierDetail lmsSupplierDetail) {
        QueryWrapper wrapper = Wrappers.query(lmsSupplierDetail);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsSupplierDetail> list(LmsSupplierDetail lmsSupplierDetail) {
        return this.list(Wrappers.query(lmsSupplierDetail));
    }


    @Override
    public LmsSupplierDetail getBySupplierId(Long supplierId) {
        return super.getOne(Wrappers.<LmsSupplierDetail>query().eq("supplier_id", supplierId));
    }


    @Override
    public boolean updateBySupplierId(LmsSupplierDetail lmsSupplierDetail) {
        if (null == lmsSupplierDetail.getSupplierId()) {
            PtAssert.fail("供应商ID 为 Null 无法更新情况数据！");
        }
        return super.update(lmsSupplierDetail, Wrappers.<LmsSupplierDetail>query().eq("supplier_id", lmsSupplierDetail.getSupplierId()));
    }


    @Override
    public boolean removeBySupplierId(Long supplierId) {
        return super.remove(Wrappers.<LmsSupplierDetail>query().eq("supplier_id", supplierId));
    }
}
