package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsSupplierRecord;
import com.patzn.lims.res.mapper.LmsSupplierRecordMapper;
import com.patzn.lims.res.service.ILmsSupplierRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 环境合同操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
@Service
public class LmsSupplierRecordServiceImpl extends BaseServiceImpl<LmsSupplierRecordMapper, LmsSupplierRecord> implements ILmsSupplierRecordService {


    @Override
    public Page<LmsSupplierRecord> page(Page<LmsSupplierRecord> page, LmsSupplierRecord lmsSupplierRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsSupplierRecord);
        if (null !=lmsSupplierRecord.getOrigin()){
            wrapper.like("origin",lmsSupplierRecord.getOrigin());
            lmsSupplierRecord.setOrigin(null);
        }
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsSupplierRecord> list(LmsSupplierRecord lmsSupplierRecord) {
        return this.list(Wrappers.query(lmsSupplierRecord));
    }
}
