package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.res.dto.LmsSupplierDTO;
import com.patzn.lims.res.entity.LmsSupplier;
import com.patzn.lims.res.entity.LmsSupplierDetail;
import com.patzn.lims.res.entity.LmsSupplierRecord;
import com.patzn.lims.res.entity.LmsSupplierType;
import com.patzn.lims.res.vo.LmsSupplierTypeVO;
import com.patzn.lims.res.vo.LmsSupplierVO;
import com.patzn.lims.res.mapper.LmsSupplierMapper;
import com.patzn.lims.res.service.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 供应商表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Service
public class LmsSupplierServiceImpl extends BaseServiceImpl<LmsSupplierMapper, LmsSupplier> implements ILmsSupplierService {

    @Autowired
    private ILmsSupplierDetailService lmsSupplierDetailService;
    @Autowired
    private ILmsSupplierTypeService lmsSupplierTypeService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsSupplierRecordService lmsSupplierRecordService;

    @Override
    public Page<LmsSupplier> page(Page<LmsSupplier> page, LmsSupplier lmsSupplier) {
        return page(page, Wrappers.query(lmsSupplier));
    }


    @Override
    public Page<LmsSupplierTypeVO> pageTypeVO(Page<LmsSupplierTypeVO> page, LmsSupplierTypeVO lmsSupplier) {

        return page.setRecords(baseMapper.pageTypeVO(page, lmsSupplier));
    }


    @Override
    public List<LmsSupplier> list(LmsSupplier lmsSupplier) {
        return list(Wrappers.query(lmsSupplier));
    }

    @Override
    public List<LmsSupplier> listNoLogin(LmsSupplier lmsSupplier) {
        return baseMapper.selectNoLogin(lmsSupplier);
    }


    @Override
    public List<LmsSupplier> listByName(String name) {
        return list( Wrappers.<LmsSupplier>query().select("id, name").eq("status", 1)
                .eq("deleted", 0).like("name", name));
    }

    @Override
    public List<LmsSupplier> listByNameNotLike(String name) {
        return list(Wrappers.<LmsSupplier>query().select("id, name").eq("status", 1)
                .eq("deleted", 0).eq("name", name));
    }


    @Override
    public List<LmsSupplier> listByNames(Set<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            List<LmsSupplier> list = new ArrayList<>();
            return list;
        }
        return super.list(Wrappers.<LmsSupplier>query().in("name", names));
    }


    @Override
    public LmsSupplierVO getVoById(Long id) {
        LmsSupplier lmsSupplier = baseMapper.selectById(id);
        if (null != lmsSupplier) {
            LmsSupplierVO vo = new LmsSupplierVO();
            LmsSupplierTypeVO typeVo = lmsSupplier.convert(LmsSupplierTypeVO.class);
            if (null != lmsSupplier.getTypeId()) {
                LmsSupplierType supplierType = lmsSupplierTypeService.getById(lmsSupplier.getTypeId());
                if (null != supplierType) {
                    typeVo.setTypeName(supplierType.getName());
                }
            }
            vo.setSupplier(typeVo);
            LmsSupplierDetail supplierDetail = lmsSupplierDetailService.getBySupplierId(id);
            if (supplierDetail != null) {
                vo.setSupplierDetail(supplierDetail);
            }
            return vo;
        }
        return null;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail) {
        lmsSupplier.setUname(LoginHelper.getAccount().getUserName());
        PtAssert.fail(StringUtils.isBlank(lmsSupplier.getName()), "供应商名称与已存在的重复");
        PtAssert.fail(super.count(Wrappers.<LmsSupplier>query().eq("name", lmsSupplier.getName())) > 0, "供应商名称重复");
        if (super.save(lmsSupplier)) {
            lmsSupplierDetail.setSupplierId(lmsSupplier.getId());
            return lmsSupplierDetailService.save(lmsSupplierDetail);
        }
        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateById(LmsSupplier lmsSupplier, LmsSupplierDetail lmsSupplierDetail) {

        PtAssert.fail(StringUtils.isBlank(lmsSupplier.getName()), "供应商名称不能为空");
        PtAssert.fail(super.count(Wrappers.<LmsSupplier>query().eq("name", lmsSupplier.getName()).ne("id", lmsSupplier.getId())) > 0, "供应商名称与已存在的重复");

        lmsSupplierDetail.setSupplierId(lmsSupplier.getId());
        LmsSupplier dbSupplier = super.getById(lmsSupplier.getId());
        LmsSupplierDetail dbDetail = lmsSupplierDetailService.getBySupplierId(lmsSupplier.getId());

        Map<String, List<Object>> map = new HashMap<>();
        List<Object> listLmsSupplier = new ArrayList<>();
        listLmsSupplier.add(lmsSupplier);
        listLmsSupplier.add(dbSupplier);
        List<Object> listLmsSupplierDetail = new ArrayList<>();
        listLmsSupplierDetail.add(lmsSupplierDetail);
        listLmsSupplierDetail.add(dbDetail);
        map.put("供应商信息对比", listLmsSupplier);
        map.put("供应商信息详情对比", listLmsSupplierDetail);
        String remark = lmsPropertyService.getObjectCompareDifferent(map, "供应商信息修改：");
        if (StringUtils.isNotBlank(remark)) {
            LmsSupplierRecord record = new LmsSupplierRecord();
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setSupplierId(lmsSupplier.getId());
            record.setType(2);
            record.setRemark(remark);
            lmsSupplierRecordService.save(record);
        }
        if (lmsSupplierDetailService.updateBySupplierId(lmsSupplierDetail)) {
            return super.updateById(lmsSupplier);
        }

        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean removeById(Long id) {
        if (lmsSupplierDetailService.removeBySupplierId(id)) {
            return super.removeById(id);
        }
        return false;
    }


    @Override
    public Page<LmsSupplier> pageByClassify(Page<LmsSupplier> page, Long classId, LmsSupplier lmsSupplier) {
        QueryWrapper ew = Wrappers.query(lmsSupplier);
        return page.setRecords(baseMapper.selectByClassifyChemical(page, classId, ew));
    }


    @Override
    public Page<LmsSupplier> pageByChemical(Page<LmsSupplier> page, Long chemicalId, LmsSupplier lmsSupplier) {
        QueryWrapper ew =Wrappers.query(lmsSupplier);
        return page.setRecords(baseMapper.selectByChemical(page, chemicalId, ew));
    }


    @Override
    public void exportSupplier(HttpServletResponse response, LmsSupplierDTO dto) {
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean importItem(MultipartFile file) {

        return false;
    }

    @Override
    public Set<String> getAllSupplier() {
        List<LmsSupplier> supplierList = super.list( Wrappers.<LmsSupplier>query().select("name").isNotNull("name"));
        Set<String> nameSet = supplierList.stream().map(lmsSupplier -> lmsSupplier.getName()).collect(Collectors.toSet());

        return nameSet;
    }

    @Override
    public Set<String> getAllSupplierByName(String supplier) {
        List<LmsSupplier> supplierList = super.list(Wrappers.<LmsSupplier>query().select("name").like("name", supplier).isNotNull("name"));
        Set<String> nameSet = supplierList.stream().filter(lmsSupplier -> StringUtils.isNotBlank(lmsSupplier.getName())).map(lmsSupplier -> lmsSupplier.getName()).collect(Collectors.toSet());
        return nameSet;
    }

    @Override
    public List<LmsSupplier> getListByIds(List<Long> ids) {
        return super.list(Wrappers.<LmsSupplier>query().in("id",ids));
    }


    @Override
    public List<LmsSupplier> getListByNames(List<String> names) {
        return super.list(Wrappers.<LmsSupplier>query().select("id", "name").in("name", names));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importSupplier(MultipartFile file) {
       return false;
    }

    @Override
    public Page<LmsSupplierTypeVO> pageSupplier(Page<LmsSupplierTypeVO> page, LmsSupplierTypeVO lmsSupplier) {

        List<LmsSupplierTypeVO> lms = baseMapper.pageSupplier(page, lmsSupplier);

        return page.setRecords(lms);
    }


    @Override
    public void exportSupplierWjl(HttpServletResponse response, LmsSupplierDTO dto) {

    }

    @Override
    public LmsSupplierTypeVO getTempVO() {
        return null;
    }


}
