package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsSupplierType;
import com.patzn.lims.res.mapper.LmsSupplierTypeMapper;
import com.patzn.lims.res.service.ILmsSupplierTypeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.List;

/**
 * <p>
 * 供应商表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-12-27
 */
@Service
public class LmsSupplierTypeServiceImpl extends BaseServiceImpl<LmsSupplierTypeMapper, LmsSupplierType> implements ILmsSupplierTypeService {


    @Override
    public Page<LmsSupplierType> page(Page<LmsSupplierType> page, LmsSupplierType lmsSupplierType) {
        QueryWrapper ew = Wrappers.query();
        ew.like(StringUtils.isNotEmpty(lmsSupplierType.getName()), "name", lmsSupplierType.getName());
        ew.like(StringUtils.isNotEmpty(lmsSupplierType.getRemark()), "remark", lmsSupplierType.getRemark());
        return page(page, ew);
    }


    @Override
    public List<LmsSupplierType> list(LmsSupplierType lmsSupplierType) {
        return list( Wrappers.<LmsSupplierType>query().select("id,name"));
    }

    @Override
    public List<LmsSupplierType> listByNames(Collection<?> names) {
        return list( Wrappers.<LmsSupplierType>query().select("id,name").in("name", names));
    }

    @Override
    public LmsSupplierType getByName(String name) {

        return super.getOne(Wrappers.<LmsSupplierType>query().eq("name", name));
    }
}
