package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.entity.LmsUserGroup;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.vo.LmsUserGroupVO;
import com.patzn.lims.res.vo.LmsUserRelGroupVO;
import com.patzn.lims.res.mapper.LmsUserGroupMapper;
import com.patzn.lims.res.service.ILmsClassifyRelGruopService;
import com.patzn.lims.res.service.ILmsUserGroupService;
import com.patzn.lims.res.service.ILmsUserRelGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Service
public class LmsUserGroupServiceImpl extends BaseServiceImpl<LmsUserGroupMapper, LmsUserGroup> implements ILmsUserGroupService {

    @Autowired
    private ILmsUserRelGroupService lmsUserRelGroupService;
    @Autowired
    private ILmsClassifyRelGruopService lmsClassifyRelGruopService;
    @Override
    public Page<LmsUserGroup> page(Page<LmsUserGroup> page, LmsUserGroup lmsUserGroup) {
        QueryWrapper wrapper = Wrappers.query(lmsUserGroup);

        return page(page, wrapper);
    }

    @Override
    public Page<LmsUserGroupVO> pageUserGroup(Page<LmsUserGroupVO> page, LmsUserGroupVO lmsUserGroup) {
        return page.setRecords(baseMapper.selectGroupList(page,lmsUserGroup));
    }


    @Override
    public List<LmsUserGroupVO> listUserGroup(LmsUserGroup lmsUserGroup) {
        return baseMapper.selectGroupListNoPage(lmsUserGroup);
    }


    @Override
    public List<LmsUserGroup> list(LmsUserGroup lmsUserGroup) {
        QueryWrapper wrapper = Wrappers.query(lmsUserGroup);
        wrapper.orderBy(true,true,"sort");
        wrapper.orderBy(true,true,"type");
        return list(wrapper);
    }

    @Override
    public List<LmsUserGroup> listNoLogin(LmsUserGroup lmsUserGroup) {
        return baseMapper.selectNoLogin(lmsUserGroup);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveUserRelGroup(Long groupId, Long[] userIds, String[] realNames, String[] usernames) {
        if (null == groupId || null == userIds) {
            PtAssert.fail("用户id或者用户组id不得为空");
            return false;
        }
        List<LmsUserRelGroup> lmsUserRelGroupList = new ArrayList<>();

        List<LmsUserRelGroup> updatelmsUserRelGroupList = new ArrayList<>();
        if (userIds.length != realNames.length) {
            PtAssert.fail("用户id与用户真实姓名不对应");
        }
        if (userIds.length != usernames.length) {
            PtAssert.fail("用户id与用户名不对应");
        }

        int length = userIds.length;
        for (int i = 0; i < length; i++) {
            long id = userIds[i];
            List<LmsUserRelGroup> relUsers = lmsUserRelGroupService.list( Wrappers.<LmsUserRelGroup>query().eq("group_id", groupId).eq("user_id", id));
            if (relUsers.size() == 0) {
                LmsUserRelGroup lmsUserRelGroup = new LmsUserRelGroup();
                lmsUserRelGroup.setGroupId(groupId);
                lmsUserRelGroup.setUserId(id);
                lmsUserRelGroup.setRealname(realNames[i]);
                lmsUserRelGroup.setUsername(usernames[i]);
                lmsUserRelGroupList.add(lmsUserRelGroup);
            } else {
                LmsUserRelGroup lmsUserRelGroup = new LmsUserRelGroup();
                lmsUserRelGroup.setId(relUsers.get(0).getId());
                lmsUserRelGroup.setRealname(realNames[i]);
                lmsUserRelGroup.setUsername(usernames[i]);
                updatelmsUserRelGroupList.add(lmsUserRelGroup);
            }
        }
        if (lmsUserRelGroupList.size() > 0 && updatelmsUserRelGroupList.size() > 0) {
            return lmsUserRelGroupService.saveBatch(lmsUserRelGroupList)
                    && lmsUserRelGroupService.updateBatchById(updatelmsUserRelGroupList);
        } else if (lmsUserRelGroupList.size() > 0) {
            return lmsUserRelGroupService.saveBatch(lmsUserRelGroupList);
        } else if (updatelmsUserRelGroupList.size() > 0) {
            return lmsUserRelGroupService.updateBatchById(updatelmsUserRelGroupList);
        } else {
            return false;
        }

    }


    @Override
    @Transactional
    public boolean deleteRelUser(Long[] ids) {
        return lmsUserRelGroupService.remove(Wrappers.<LmsUserRelGroup>query().in("id",ids));
    }


    @Override
    public Page<LmsUserRelGroup> getPageRelUser(Page<LmsUserRelGroup> page, LmsUserRelGroup lmsUserRelGroup) {
      return  lmsUserRelGroupService.page(page,lmsUserRelGroup);
    }

    @Override
    public List<LmsUserGroup>  listGroupByNameList(Collection<String> groupNames) {
        return super.list(Wrappers.<LmsUserGroup>query().select("id","name").in("name",groupNames));
    }

    @Override
    public List<LmsUserGroup>  listGroupByIds(Collection<Long> ids) {
        return super.list(Wrappers.<LmsUserGroup>query().in("id",ids));
    }

    @Override
    public List<LmsUserGroup> getByUserId(Long userId) {
        return baseMapper.selectListByUserId(userId);
    }


    @Override
    public List<LmsUserGroup> getNoLeaderGroup(Collection<Long> groupIds, Long userId) {
        return baseMapper.selectNoLeaderGroupList(groupIds,userId);
    }

    @Override
    public List<LmsUserGroup> getListIdNotIn(Collection<Long> groupIds) {
        return baseMapper.selectListIdNotInGroupList(groupIds);
    }

    @Override
    public Page<LmsUserGroupVO> pageListGroupByUserId(Page<LmsUserGroupVO> page,Long uid) {
        return page.setRecords(baseMapper.selectGroupListByUserId(page,uid));
    }

    @Override
    public Page<LmsUserGroupVO> pageListGroups(Page<LmsUserGroupVO> page, LmsUserGroupVO vo) {
        return page.setRecords(baseMapper.selectGroups(page,vo));
    }

    @Override
    public Page<LmsUserRelGroup> getPageRelUserManyGroup(Page<LmsUserRelGroup> page, LmsUserRelGroupVO vo) {
        return lmsUserRelGroupService.pageUser(page,vo);
    }


    @Override
    public List<LmsUserGroup> getByLeaderUserId(Long userId) {
        return baseMapper.getByLeaderUserId(userId);
    }

}
