package com.patzn.lims.res.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.dto.LmsUserGroupDTO;
import com.patzn.lims.res.entity.LmsUserRelGroup;
import com.patzn.lims.res.vo.LmsUserRelGroupVO;
import com.patzn.lims.res.mapper.LmsUserRelGroupMapper;
import com.patzn.lims.res.service.ILmsUserRelGroupService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 用户关联组表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-03-28
 */
@Service
public class LmsUserRelGroupServiceImpl extends BaseServiceImpl<LmsUserRelGroupMapper, LmsUserRelGroup> implements ILmsUserRelGroupService {


    @Override
    public Page<LmsUserRelGroup> page(Page<LmsUserRelGroup> page, LmsUserRelGroup lmsUserRelGroup) {
        QueryWrapper wrapper = Wrappers.<LmsUserRelGroup>query().select("DISTINCT ON (user_id) * ");
        if (null != lmsUserRelGroup.getGroupId()) {
            wrapper.eq("group_id", lmsUserRelGroup.getGroupId());
            lmsUserRelGroup.setGroupId(null);
        }
        if (null != lmsUserRelGroup.getRealname()) {
            wrapper.like("realname", lmsUserRelGroup.getRealname());
            lmsUserRelGroup.setRealname(null);
        }
        wrapper.orderBy(true,true,"user_id");
        wrapper.orderBy(true,true,"realname");
        return page(page, wrapper);
    }

    @Override
    public Page<LmsUserRelGroup> pageUser(Page<LmsUserRelGroup> page, LmsUserRelGroupVO vo) {
        List<LmsUserRelGroup> relGroups = baseMapper.selectRelGroups(page, vo);
        return page.setRecords(relGroups);
    }


    @Override
    public List<LmsUserRelGroup> list(LmsUserRelGroup lmsUserRelGroup) {
        return list(Wrappers.query(lmsUserRelGroup));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean setLeader(Long[] ids, String leader) {
        LmsUserRelGroup lmsUserRelGroup = new LmsUserRelGroup();
        if ("0".equals(leader)) {
            lmsUserRelGroup.setLeader(1);
        } else {
            lmsUserRelGroup.setLeader(0);
        }


        return super.update(lmsUserRelGroup, Wrappers.<LmsUserRelGroup>query().in("id", ids));

    }

    @Override
    public List<Long> getAllUserIdByGroup(Long groupId) {
        List<LmsUserRelGroup> groupUserList = super.list(Wrappers.<LmsUserRelGroup>query().eq("group_id", groupId));
        if (null != groupUserList) {
            return groupUserList.stream().map(lmsUserRelGroup -> {
                Long userId = lmsUserRelGroup.getUserId();
                return userId;
            }).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<LmsUserRelGroup> listUserByGroupIdAndUserName(LmsUserGroupDTO lmsUserGroupDTO) {
        return list(Wrappers.<LmsUserRelGroup>query().select("user_id", "realname").eq("group_id", lmsUserGroupDTO.getGroupId()).eq("realname", lmsUserGroupDTO.getUserName()));
    }

    @Override
    public List<Long> getAllGroupIdByUserId(Long userId) {
        PtAssert.fail(null == userId, "用户id未传递");
        List<LmsUserRelGroup> groupUserList = super.list(Wrappers.<LmsUserRelGroup>query().eq("user_id", userId));
        if (null != groupUserList) {
            return groupUserList.stream().map(lmsUserRelGroup -> lmsUserRelGroup.getGroupId()).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<LmsUserRelGroup> listGroupUserByUserId(Long currentUserId) {
        if (null == currentUserId) {
            return new ArrayList<>();
        }
        List<LmsUserRelGroup> groupUserList = super.list(Wrappers.<LmsUserRelGroup>query().eq("user_id", currentUserId));
        if (null != groupUserList) {
            List<Long> groupIds = groupUserList.stream().map(lmsUserRelGroup -> lmsUserRelGroup.getGroupId()).collect(Collectors.toList());
            return super.list(Wrappers.<LmsUserRelGroup>query().select("user_id,realname").in("group_id", groupIds)
                    .ne("user_id", currentUserId).groupBy("user_id,realname"));
        }
        return new ArrayList<>();
    }

    @Override
    public List<LmsUserRelGroup> getUserByGroupIds(Collection<Long>groupIds) {
        return super.list(Wrappers.<LmsUserRelGroup>query().select("id","user_id","group_id").in("group_id",groupIds));
    }

    @Override
    public List<LmsUserRelGroup> getUserByleader() {
        return baseMapper.getUserByleader();
    }

    @Override
    public List<LmsUserRelGroup> getListUserByGroupIdByLeader(LmsUserGroupDTO  lmsUserRelGroup) {
        PtAssert.fail(null==lmsUserRelGroup,"找不到组！");
        return super.list(Wrappers.<LmsUserRelGroup>query().select("id","user_id","group_id","leader","realname").eq("group_id",lmsUserRelGroup.getGroupId()));
    }

    @Override
    public     List<LmsUserRelGroup> getUserByGroupIdsLeader(Collection<Long> groupIds){
        PtAssert.fail(CollectionUtils.isEmpty(groupIds),"找不到组！");
        return super.list(Wrappers.<LmsUserRelGroup>query().select("id","user_id","group_id","leader","realname").in("group_id",groupIds));
    }
}
