package com.patzn.lims.res.vo;

import com.patzn.lims.res.entity.LmsExpensesAttachment;
import com.patzn.lims.res.entity.LmsExpensesInfo;
import com.patzn.lims.res.entity.LmsExpensesList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 报销信息
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-01
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsExpensesInfoVO extends LmsExpensesInfo {

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("是否显示撤回按钮")
    private Boolean showButtonWithdraw;

    @ApiModelProperty("申请日期开始")
    private Date applyDateBegin;

    @ApiModelProperty("申请日期结束")
    private Date applyDateEnd;

    @ApiModelProperty("部门ID")
    private Long departmentId;

    @ApiModelProperty("报销列表List")
    private List<LmsExpensesList> expensesLists;

    @ApiModelProperty("附件列表的List")
    private List<LmsExpensesAttachment> attachments;

    @ApiModelProperty("需要删除的 LmsExpenseList 的 ids")
    private List<Long> deletedListIds;

    @ApiModelProperty("需要删除的 LmsExpenseAttachment 的 ids")
    private List<Long> deletedAttachIds;

    @ApiModelProperty("用户id的List")
    private List<Long> userIdList;

    @ApiModelProperty("差旅报销单数量")
    private BigDecimal travelAmount;

    @ApiModelProperty("费用报销单数量")
    private BigDecimal costAmount;

    @ApiModelProperty("车辆费用报销数量")
    private BigDecimal carCostAmount;

    @ApiModelProperty("付款申请单数量")
    private BigDecimal paymentAmount;

    @ApiModelProperty("借款单数量")
    private BigDecimal borrowAmount;

    @ApiModelProperty("是否在组里")
    private Boolean isInGroup;

}
