package com.patzn.lims.res.vo;

import com.patzn.lims.res.entity.LmsSignatureInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.InputStream;

/**
 * <p>
 * 签章表
 * </p>
 *
 * @author ldx
 * @since 2018-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel
public class LmsSignatureInfoVO extends LmsSignatureInfo {

    @ApiModelProperty(value = "签章类别值")
    private Integer classifyValue;

    @ApiModelProperty(value = "印章位置，左偏移和上偏移结合")
    private String location;

    @ApiModelProperty(value = "印章的图片的 InputStream")
    private InputStream inputStream;

}
