package com.patzn.lims.res.vo;

import com.patzn.lims.res.entity.LmsUserRelGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 用户组 VO
 * </p>
 *
 * @author ldx
 * @since 2018-12-19
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsUserRelGroupVO extends LmsUserRelGroup {

    @ApiModelProperty(value = "用户组ids")
    private List<Long> groupIds;

    @ApiModelProperty(value = "任务量")
    private Integer total;

    @ApiModelProperty(value = "userId的字符串类型")
    private String userIdStr;

    public String getUserIdStr() {
        if (getUserId() == null) {
            return null;
        }
        return getUserId() + "";
    }
}
