package com.patzn.lims.res.vo;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author zhaokai
 * @since 2019-07-23
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
public class OperationalRecord extends BaseEntity {

    @ApiModelProperty("委托|样品|项目的id")
    private Long linkId;

    @ApiModelProperty("类型：1委托|2样品|3项目|4报告")
    private Integer type;

    @ApiModelProperty("操作阶段")
    private String origin;

    @ApiModelProperty("目标阶段")
    private String target;

    @ApiModelProperty("操作人")
    private String operator;

    @ApiModelProperty("操作时间")
    private Date ctime;

}
