package com.patzn.lims.res.vo;

import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author zhaokai
 * @since 2019-09-10
 */
@Data
@Accessors(chain = true)
@ApiModel
public class ReportMakeMsgVO extends BaseEntity {

    public ReportMakeMsgVO() {

    }

    public ReportMakeMsgVO(String service, String content, String seriesNo) {
        this.service = service;
        this.content = content;
        this.seriesNo = seriesNo;
    }

    public ReportMakeMsgVO(String service, String content, String seriesNo, boolean success) {
        this.service = service;
        this.content = content;
        this.seriesNo = seriesNo;
        this.success = success;
    }

    @ApiModelProperty("服务")
    private String service;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("是否成功")
    private boolean success = true;

    @ApiModelProperty("序列号")
    private String seriesNo;

}
