package com.patzn.lims.security.controller;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.kisso.common.CookieHelper;
import com.baomidou.kisso.common.IpHelper;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.security.token.SSOToken;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.security.payload.LoginRequest;
import com.patzn.lims.sys.entity.SysUser;
import com.patzn.lims.sys.enums.WxTypeEnum;
import com.patzn.lims.sys.service.ISysUserService;
import io.jsonwebtoken.Jwts;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Slf4j
@Controller
@RequestMapping("/v")
public class LoginHelpController extends SuperController {
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private PasswordEncoder passwordEncoder;





    @Login(action = Action.Skip)
    @RequestMapping("/help")
    public String loginHome() {

        return ("login");
    }


    /**
     * JSON 序列化测试
     */
    @GetMapping("/hello")
    public PtResult testJson() {
        return success(new TestJson(1233635718841012218L, WxTypeEnum.MA));
    }



    @Data
    @AllArgsConstructor
    class TestJson {
        private Long id;
        private WxTypeEnum wxTypeEnum;
    }
}
