//package com.patzn.lims.security.controller;
//
//import com.baomidou.kisso.SSOHelper;
//import com.baomidou.kisso.annotation.Action;
//import com.baomidou.kisso.annotation.Login;
//import com.baomidou.kisso.common.CookieHelper;
//import com.baomidou.kisso.common.util.HttpUtil;
//import com.patzn.lims.core.web.SuperController;
//import ops.china.service.upms.config.ServiceConfig;
//import ops.china.service.web.SuperController;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.ui.Model;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.PathVariable;
//import org.springframework.web.bind.annotation.ResponseBody;
//
///**
// * <p>
// * 网关授权控制器
// * </p>
// *
// * @author hubin
// * @since 2018-04-26
// */
//@Controller
//public class WebController extends SuperController {
//    @Autowired
//    private ServiceConfig serviceConfig;
//    private final String PLATFORM_OIL = "oil";
//    private final String PLATFORM_SLIMS = "slims";
//
//    /**
//     * 登录首页
//     * platform 平台 slims 校园云
//     */
//    @Login(action = Action.Skip)
//    @GetMapping(value = {"/", "/login"})
//    public String login(Model model, String platform) {
//        String retUrl = request.getHeader("referer");
//        if (null == retUrl || retUrl.contains("/activation")
//                || (!retUrl.contains("localhost")
//                && !retUrl.contains("ops.com"))) {
//            retUrl = serviceConfig.getSysUrl();
//        }
//        if (null != SSOHelper.getSSOToken(request)
//                && null != CookieHelper.findCookieByName(request, "ln")) {
//            // 已登录逻辑处理
//            HttpUtil.sendRedirect(response, retUrl);
//        }
//        if (StringUtils.isNotEmpty(platform)) {
//            // 处理 2 中特殊情况
//            if(PLATFORM_OIL.equalsIgnoreCase(platform)) {
//                platform = PLATFORM_OIL;
//            } if(PLATFORM_SLIMS.equalsIgnoreCase(platform)) {
//                platform = PLATFORM_SLIMS;
//            }
//        }
//        model.addAttribute("platform", platform);
//        model.addAttribute("wxloginUrl", serviceConfig.getWxloginUrl());
//        model.addAttribute("ssoUrl", serviceConfig.getLoginUrl());
//        model.addAttribute("otpUrl", serviceConfig.getOptLoginUrl());
//        model.addAttribute("retUrl", retUrl);
//        return "login";
//    }
//
//
//    /**
//     * 用户激活
//     */
//    @GetMapping("/activation")
//    public String activation(Model model, String platform) {
//        model.addAttribute("platform", platform);
//        model.addAttribute("activationUrl", serviceConfig.getActivationUrl());
//        return "activation";
//    }
//
//
//    /**
//     * <p>
//     * 微信绑定或者登录授权
//     * </p>
//     */
//    @GetMapping("/wechat_{type}")
//    public String wechat(Model model, @PathVariable("type") int type, String code, String env) {
//        model.addAttribute("wechatUrl", getApi(env) + "/mapper.mapper.mapper.res/v1/sso/wechat/" + code);
//        model.addAttribute("sysUrl", serviceConfig.getSysUrl());
//        return "wechat";
//    }
//
//
//    /**
//     * <p>
//     * 微信登录
//     * </p>
//     */
//    @ResponseBody
//    @GetMapping("/wxlogin")
//    public void wxlogin(String code, String env) {
//        redirectTo(1, code, env);
//    }
//
//
//    /**
//     * <p>
//     * 微信绑定
//     * </p>
//     */
//    @ResponseBody
//    @GetMapping("/wxbind")
//    public void wxbind(String code, String env) {
//        redirectTo(0, code, env);
//    }
//
//
//    /**
//     * <p>
//     * 重定向到指定地址
//     * </p>
//     *
//     * @param type 0、 绑定 1、登录
//     * @param code 微信授权码
//     * @param env  运行环境
//     */
//    private void redirectTo(int type, String code, String env) {
//        try {
//            StringBuilder redirectUrl = new StringBuilder();
//            redirectUrl.append(getApi(env)).append("/wechat_").append(type);
//            redirectUrl.append("?code=").append(code);
//            redirectUrl.append("&env=").append(env);
//            response.sendRedirect(redirectUrl.toString());
//        } catch (Exception et) {
//            // to do nothing
//        }
//    }
//
//
//    private String getApi(String env) {
//        String url = "http://sso.ops.com";
//        if ("development".equals(env)) {
//            url = "http://api.dev.ops.com:7000";
//        } else if ("testing".equals(env)) {
//            url = "http://sso.test.ops.com";
//        }
//        return url;
//    }
//}
