package com.patzn.lims.staff.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.cloud.commons.toolkit.UploadUtils;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.staff.entity.LmsStaffCertificateAttachment;
import com.patzn.lims.staff.service.ILmsStaffCertificateAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 证书编号附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-27
 */
@Api(description = "证书编号附件表")
@RestController
@RequestMapping("/v1/staff_certificate_attachment")
public class LmsStaffCertificateAttachmentController extends ServiceController<ILmsStaffCertificateAttachmentService,LmsStaffCertificateAttachment> {

    @Autowired
    private ILmsStaffCertificateAttachmentService lmsStaffCertificateAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsStaffCertificateAttachment>> getPage(LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        return success(lmsStaffCertificateAttachmentService.page(getPage(), lmsStaffCertificateAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsStaffCertificateAttachment>> getList(LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        return success(lmsStaffCertificateAttachmentService.list(lmsStaffCertificateAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsStaffCertificateAttachment> get(@PathVariable("id") Long id) {
        return success(lmsStaffCertificateAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        lmsStaffCertificateAttachment.setId(id);
        return success(lmsStaffCertificateAttachmentService.updateById(lmsStaffCertificateAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsStaffCertificateAttachment lmsStaffCertificateAttachment) {
        return success(lmsStaffCertificateAttachmentService.save(lmsStaffCertificateAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsStaffCertificateAttachmentService.remove(Wrappers.<LmsStaffCertificateAttachment>query().in("id", ids)));
	}


    @ApiOperation(value = "上传证书附件", notes = "上传证书附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "certificateId", value = "证书 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{certificateId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("certificateId") Long certificateId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }
        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsStaffCertificateAttachmentService.save(certificateId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载证书附件文件", notes = "根据 id 下载证书附件文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsStaffCertificateAttachmentService.download(id, response);
    }

}
